/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.api.IPos;

public class BlockPosWrapper
implements IPos {
    private final BlockPos blockPos;
    private final double x;
    private final double y;
    private final double z;

    public BlockPosWrapper(double bx, double by, double bz) {
        this.x = Math.min(3.0E7, Math.max(-3.0E7, bx));
        this.y = Math.min(255.0, Math.max(0.0, by));
        this.z = Math.min(3.0E7, Math.max(-3.0E7, bz));
        this.blockPos = new BlockPos(this.x, this.y, this.z);
    }

    public BlockPosWrapper(BlockPos pos) {
        this.blockPos = pos;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    @Override
    public IPos add(double bx, double by, double bz) {
        return new BlockPosWrapper(this.x + bx, this.y + by, this.z + bz);
    }

    @Override
    public IPos add(IPos pos) {
        return new BlockPosWrapper(this.x + pos.getX(), this.y + pos.getY(), this.z + pos.getZ());
    }

    @Override
    public double distanceTo(double bx, double by, double bz) {
        double d0 = this.x - bx;
        double d2 = this.y - by;
        double d3 = this.z - bz;
        return Math.sqrt(d0 * d0 + d2 * d2 + d3 * d3);
    }

    @Override
    public double distanceTo(IPos pos) {
        return this.distanceTo(pos.getX(), pos.getX(), pos.getX());
    }

    @Override
    public IPos down() {
        return this.down(1.0);
    }

    @Override
    public IPos down(double n) {
        return new BlockPosWrapper(this.x, this.y - n, this.z);
    }

    @Override
    public IPos east() {
        return this.east(1.0);
    }

    @Override
    public IPos east(double n) {
        return new BlockPosWrapper(this.x + n, this.y, this.z);
    }

    @Override
    public BlockPos getMCBlockPos() {
        return this.blockPos;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double[] normalize() {
        double d = Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
        return new double[]{this.x / d, this.y / d, this.z / d};
    }

    @Override
    public IPos north() {
        return this.north(1.0);
    }

    @Override
    public IPos north(double n) {
        return new BlockPosWrapper(this.x, this.y, this.z - n);
    }

    @Override
    public IPos offset(int direction) {
        return this.offset(direction, 1.0);
    }

    @Override
    public IPos offset(int direction, double n) {
        if (n == 0.0) {
            return this;
        }
        EnumFacing d = EnumFacing.func_176731_b((int)direction);
        return new BlockPosWrapper(this.x + (double)d.func_82601_c() * n, this.y + (double)d.func_96559_d() * n, this.z + (double)d.func_82599_e() * n);
    }

    @Override
    public IPos south() {
        return this.south(1.0);
    }

    @Override
    public IPos south(double n) {
        return new BlockPosWrapper(this.x, this.y, this.z + n);
    }

    @Override
    public IPos subtract(double bx, double by, double bz) {
        return new BlockPosWrapper(this.x - bx, this.y - by, this.z - bz);
    }

    @Override
    public IPos subtract(IPos pos) {
        return this.subtract(pos.getX(), pos.getY(), pos.getZ());
    }

    public String toString() {
        return "BlockPosWrapper {pos: [" + this.x + ", " + this.y + ", " + this.z + "]; mcPos: [" + this.blockPos.func_177958_n() + ", " + this.blockPos.func_177956_o() + ", " + this.blockPos.func_177952_p() + "]}";
    }

    @Override
    public IPos up() {
        return this.up(1.0);
    }

    @Override
    public IPos up(double n) {
        return new BlockPosWrapper(this.x, this.y + n, this.z);
    }

    @Override
    public IPos west() {
        return this.west(1.0);
    }

    @Override
    public IPos west(double n) {
        return new BlockPosWrapper(this.x - n, this.y, this.z);
    }
}

